package gov.va.vamf.scheduling.direct.datalayer.facility;

import agilex.commons.NullChecker;
import gov.va.vamf.scheduling.direct.domain.SiteSupportingVAR;
import gov.va.vamf.scheduling.direct.domain.SiteSupportingVARs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collection;

@Service
public class SiteSupportingVARService {

    @Autowired
    private SiteSupportingVARRepository siteSupportingVARRepository;

    public SiteSupportingVARs fetch() {
        return siteSupportingVARRepository.findAll();
    }

    public SiteSupportingVAR fetchById(String id) {
        return siteSupportingVARRepository.findById(id);
    }

    public SiteSupportingVARs fetchByIdIn(Collection<String> siteCodes) {
        return siteSupportingVARRepository.findByIdIn(siteCodes);
    }

    public SiteSupportingVARs fetchByIdInCsv(String siteCodes) {
        if(NullChecker.isNullish(siteCodes)) return fetch();
        return siteSupportingVARRepository.findByIdIn(Arrays.asList(siteCodes.split(",")));
    }

    public SiteSupportingVAR save(SiteSupportingVAR siteSupportingVAR) {
        return siteSupportingVARRepository.save(siteSupportingVAR);
    }
}
